/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassConstants;
import COM.rl.obf.classfile.ClassCpInfo;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.CodeAttrInfo;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.CpInfo;
import COM.rl.obf.classfile.DoubleCpInfo;
import COM.rl.obf.classfile.FieldInfo;
import COM.rl.obf.classfile.FieldrefCpInfo;
import COM.rl.obf.classfile.FlagHashtable;
import COM.rl.obf.classfile.LongCpInfo;
import COM.rl.obf.classfile.MethodInfo;
import COM.rl.obf.classfile.MethodrefCpInfo;
import COM.rl.obf.classfile.NameAndTypeCpInfo;
import COM.rl.obf.classfile.NameMapper;
import COM.rl.obf.classfile.RefCpInfo;
import COM.rl.obf.classfile.StringCpInfo;
import COM.rl.obf.classfile.StringCpInfoFlags;
import COM.rl.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassFile
implements ClassConstants {
    public static final String SEP_REGULAR = "/";
    public static final String SEP_INNER = "$";
    private static final String CLASS_FORNAME_NAME_DESCRIPTOR = "forName(Ljava/lang/String;)Ljava/lang/Class;";
    private static final String[] DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY = new String[]{"getDeclaredField(Ljava/lang/String;)Ljava/lang/reflect/Field;", "getField(Ljava/lang/String;)Ljava/lang/reflect/Field;", "getDeclaredMethod(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getMethod(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"};
    private static final String LOG_DANGER_CLASS_PRE = "     Your class ";
    private static final String LOG_DANGER_CLASS_MID = " calls the java/lang/Class method ";
    private static final String LOG_CLASS_FORNAME_MID = " uses '.class' or calls java/lang/Class.";
    private static final String[] DANGEROUS_CLASSLOADER_SIMPLENAME_DESCRIPTOR_ARRAY = new String[]{"defineClass(Ljava/lang/String;[BII)Ljava/lang/Class;", "findLoadedClass(Ljava/lang/String;)Ljava/lang/Class;", "findSystemClass(Ljava/lang/String;)Ljava/lang/Class;", "loadClass(Ljava/lang/String;)Ljava/lang/Class;", "loadClass(Ljava/lang/String;Z)Ljava/lang/Class;"};
    private static final String LOG_DANGER_CLASSLOADER_PRE = "     Your class ";
    private static final String LOG_DANGER_CLASSLOADER_MID = " calls the java/lang/ClassLoader method ";
    private int u4magic;
    private int u2minorVersion;
    private int u2majorVersion;
    private ConstantPool constantPool;
    private int u2accessFlags;
    private int u2thisClass;
    private int u2superClass;
    private List<Integer> u2interfaces;
    private List<FieldInfo> fields;
    private List<MethodInfo> methods;
    private List<AttrInfo> attributes;
    private CpInfo cpIdString = null;

    public static ClassFile create(DataInput din) throws IOException, ClassFileException {
        if (din == null) {
            throw new IOException("No input stream was provided.");
        }
        ClassFile cf = new ClassFile();
        cf.read(din);
        return cf;
    }

    public static List<String> parseMethodDescriptor(String descriptor) throws ClassFileException {
        String descriptorPart = descriptor;
        ArrayList<String> names = new ArrayList<String>();
        if (descriptorPart.charAt(0) != '(') {
            throw new ClassFileException("Illegal method descriptor: " + descriptor);
        }
        descriptorPart = descriptorPart.substring(1);
        String type = "";
        boolean foundParamEnd = false;
        int returnParamCnt = 0;
        block6: while (descriptorPart.length() > 0) {
            switch (descriptorPart.charAt(0)) {
                case '[': {
                    type = type + "[";
                    descriptorPart = descriptorPart.substring(1);
                    continue block6;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    names.add(ClassFile.translateType(type + descriptorPart.substring(0, 1)));
                    descriptorPart = descriptorPart.substring(1);
                    type = "";
                    if (!foundParamEnd) continue block6;
                    ++returnParamCnt;
                    continue block6;
                }
                case ')': {
                    descriptorPart = descriptorPart.substring(1);
                    foundParamEnd = true;
                    continue block6;
                }
                case 'L': {
                    int pos = descriptorPart.indexOf(59) + 1;
                    names.add(ClassFile.translateType(type + descriptorPart.substring(0, pos)));
                    descriptorPart = descriptorPart.substring(pos);
                    type = "";
                    if (!foundParamEnd) continue block6;
                    ++returnParamCnt;
                    continue block6;
                }
            }
            throw new ClassFileException("Illegal method descriptor: " + descriptor);
        }
        if (returnParamCnt != 1) {
            throw new ClassFileException("Illegal method descriptor: " + descriptor);
        }
        return names;
    }

    public static String translateType(String inName) throws ClassFileException {
        String outName = null;
        switch (inName.charAt(0)) {
            case '[': {
                outName = ClassFile.translate(inName);
                break;
            }
            case 'B': {
                outName = Byte.TYPE.getName();
                break;
            }
            case 'C': {
                outName = Character.TYPE.getName();
                break;
            }
            case 'D': {
                outName = Double.TYPE.getName();
                break;
            }
            case 'F': {
                outName = Float.TYPE.getName();
                break;
            }
            case 'I': {
                outName = Integer.TYPE.getName();
                break;
            }
            case 'J': {
                outName = Long.TYPE.getName();
                break;
            }
            case 'S': {
                outName = Short.TYPE.getName();
                break;
            }
            case 'Z': {
                outName = Boolean.TYPE.getName();
                break;
            }
            case 'V': {
                outName = Void.TYPE.getName();
                break;
            }
            case 'L': {
                int pos = inName.indexOf(59);
                outName = ClassFile.translate(inName.substring(1, pos));
                break;
            }
            default: {
                throw new ClassFileException("Illegal field or method name: " + inName);
            }
        }
        return outName;
    }

    public static String translate(String name) {
        return name.replace('/', '.');
    }

    public static String backTranslate(String name) {
        return name.replace('.', '/');
    }

    public boolean hasIncompatibleVersion() {
        return this.u2majorVersion > 50;
    }

    public int getMajorVersion() {
        return this.u2majorVersion;
    }

    private ClassFile() {
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u4magic = din.readInt();
        this.u2minorVersion = din.readUnsignedShort();
        this.u2majorVersion = din.readUnsignedShort();
        if (this.u4magic != -889275714) {
            throw new ClassFileException("Invalid magic number in class file.");
        }
        int u2constantPoolCount = din.readUnsignedShort();
        ArrayList<CpInfo> cpInfo = new ArrayList<CpInfo>(u2constantPoolCount);
        cpInfo.add(null);
        for (int i = 1; i < u2constantPoolCount; ++i) {
            CpInfo cp = CpInfo.create(din);
            cpInfo.add(cp);
            if (!(cp instanceof LongCpInfo) && !(cp instanceof DoubleCpInfo)) continue;
            ++i;
            cpInfo.add(null);
        }
        this.constantPool = new ConstantPool(this, cpInfo);
        this.u2accessFlags = din.readUnsignedShort();
        this.u2thisClass = din.readUnsignedShort();
        this.u2superClass = din.readUnsignedShort();
        int u2interfacesCount = din.readUnsignedShort();
        this.u2interfaces = new ArrayList<Integer>(u2interfacesCount);
        for (int i = 0; i < u2interfacesCount; ++i) {
            this.u2interfaces.add(din.readUnsignedShort());
        }
        int u2fieldsCount = din.readUnsignedShort();
        this.fields = new ArrayList<FieldInfo>(u2fieldsCount);
        for (int i = 0; i < u2fieldsCount; ++i) {
            this.fields.add(FieldInfo.create(din, this));
        }
        int u2methodsCount = din.readUnsignedShort();
        this.methods = new ArrayList<MethodInfo>(u2methodsCount);
        for (int i = 0; i < u2methodsCount; ++i) {
            this.methods.add(MethodInfo.create(din, this));
        }
        int u2attributesCount = din.readUnsignedShort();
        this.attributes = new ArrayList<AttrInfo>(u2attributesCount);
        for (int i = 0; i < u2attributesCount; ++i) {
            this.attributes.add(AttrInfo.create(din, this, ClassConstants.AttrSource.CLASS));
        }
    }

    public void setIdString(String id) {
        this.cpIdString = id != null ? new Utf8CpInfo(id) : null;
    }

    public int getModifiers() {
        return this.u2accessFlags;
    }

    public String getName() throws ClassFileException {
        return this.toName(this.u2thisClass);
    }

    public String getSuper() throws ClassFileException {
        if (this.u2superClass == 0) {
            return null;
        }
        return this.toName(this.u2superClass);
    }

    public List<String> getInterfaces() throws ClassFileException {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int intf : this.u2interfaces) {
            interfaces.add(this.toName(intf));
        }
        return interfaces;
    }

    private String toName(int u2index) throws ClassFileException {
        CpInfo classEntry = this.getCpEntry(u2index);
        if (classEntry instanceof ClassCpInfo) {
            ClassCpInfo entry = (ClassCpInfo)classEntry;
            return entry.getName(this);
        }
        throw new ClassFileException("Inconsistent Constant Pool in class file.");
    }

    public List<MethodInfo> getMethods() {
        return this.methods;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    protected CpInfo getCpEntry(int cpIndex) throws ClassFileException {
        return this.constantPool.getCpEntry(cpIndex);
    }

    public int remapUtf8To(String newString, int oldIndex) throws ClassFileException {
        return this.constantPool.remapUtf8To(newString, oldIndex);
    }

    protected String getUtf8(int cpIndex) throws ClassFileException {
        CpInfo utf8Entry = this.getCpEntry(cpIndex);
        if (utf8Entry instanceof Utf8CpInfo) {
            Utf8CpInfo entry = (Utf8CpInfo)utf8Entry;
            return entry.getString();
        }
        throw new ClassFileException("Not UTF8Info");
    }

    public List<String> listDangerMethods(List<String> list) {
        for (CpInfo cpInfo : this.constantPool) {
            if (!(cpInfo instanceof MethodrefCpInfo)) continue;
            try {
                MethodrefCpInfo entry = (MethodrefCpInfo)cpInfo;
                ClassCpInfo classEntry = (ClassCpInfo)this.getCpEntry(entry.getClassIndex());
                String className = this.getUtf8(classEntry.getNameIndex());
                NameAndTypeCpInfo ntEntry = (NameAndTypeCpInfo)this.getCpEntry(entry.getNameAndTypeIndex());
                String name = this.getUtf8(ntEntry.getNameIndex());
                String descriptor = this.getUtf8(ntEntry.getDescriptorIndex());
                if (className.equals("java/lang/Class")) {
                    if (CLASS_FORNAME_NAME_DESCRIPTOR.equals(name + descriptor)) {
                        list.add("     Your class " + this.getName() + LOG_CLASS_FORNAME_MID + CLASS_FORNAME_NAME_DESCRIPTOR);
                        continue;
                    }
                    if (!Arrays.asList(DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY).contains(name + descriptor)) continue;
                    list.add("     Your class " + this.getName() + LOG_DANGER_CLASS_MID + name + descriptor);
                    continue;
                }
                if (!Arrays.asList(DANGEROUS_CLASSLOADER_SIMPLENAME_DESCRIPTOR_ARRAY).contains(name + descriptor)) continue;
                list.add("     Your class " + this.getName() + LOG_DANGER_CLASSLOADER_MID + name + descriptor);
            }
            catch (ClassFileException e) {}
        }
        return list;
    }

    public void markUtf8Refs() throws ClassFileException {
        for (FieldInfo fd : this.fields) {
            fd.markUtf8Refs(this.constantPool);
        }
        for (MethodInfo md : this.methods) {
            md.markUtf8Refs(this.constantPool);
        }
        for (AttrInfo at : this.attributes) {
            at.markUtf8Refs(this.constantPool);
        }
        for (CpInfo cpInfo : this.constantPool) {
            if (!(cpInfo instanceof NameAndTypeCpInfo) && !(cpInfo instanceof ClassCpInfo) && !(cpInfo instanceof StringCpInfo)) continue;
            cpInfo.markUtf8Refs(this.constantPool);
        }
    }

    public void markNTRefs() throws ClassFileException {
        for (CpInfo cpInfo : this.constantPool) {
            if (!(cpInfo instanceof RefCpInfo)) continue;
            cpInfo.markNTRefs(this.constantPool);
        }
    }

    public void trimAttrsExcept(List<String> extraAttrs) {
        ArrayList<String> keepAttrs = new ArrayList<String>(Arrays.asList(ClassConstants.REQUIRED_ATTRS));
        keepAttrs.addAll(extraAttrs);
        for (FieldInfo fd : this.fields) {
            fd.trimAttrsExcept(keepAttrs);
        }
        for (MethodInfo md : this.methods) {
            md.trimAttrsExcept(keepAttrs);
        }
        ArrayList<AttrInfo> delAttrs = new ArrayList<AttrInfo>();
        for (AttrInfo at : this.attributes) {
            if (keepAttrs.contains(at.getAttrName())) {
                at.trimAttrsExcept(keepAttrs);
                continue;
            }
            delAttrs.add(at);
        }
        this.attributes.removeAll(delAttrs);
    }

    public void updateRefCount() throws ClassFileException {
        this.constantPool.updateRefCount();
    }

    public void trimAttrs(NameMapper nm) {
        this.trimAttrsExcept(nm.getAttrsToKeep());
    }

    public void remap(NameMapper nm, PrintWriter log, boolean enableMapClassString) throws ClassFileException {
        CpInfo cpInfo;
        int i;
        String remapDesc;
        String desc;
        ClassCpInfo cls = (ClassCpInfo)this.getCpEntry(this.u2thisClass);
        String thisClassName = this.getUtf8(cls.getNameIndex());
        for (FieldInfo fd : this.fields) {
            if (!fd.isSynthetic()) {
                String name = this.getUtf8(fd.getNameIndex());
                String remapName = nm.mapField(thisClassName, name);
                fd.setNameIndex(this.constantPool.remapUtf8To(remapName, fd.getNameIndex()));
            }
            desc = this.getUtf8(fd.getDescriptorIndex());
            remapDesc = nm.mapDescriptor(desc);
            fd.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc, fd.getDescriptorIndex()));
        }
        for (MethodInfo md : this.methods) {
            desc = this.getUtf8(md.getDescriptorIndex());
            if (!md.isSynthetic()) {
                String name = this.getUtf8(md.getNameIndex());
                String remapName = nm.mapMethod(thisClassName, name, desc);
                md.setNameIndex(this.constantPool.remapUtf8To(remapName, md.getNameIndex()));
            }
            remapDesc = nm.mapDescriptor(desc);
            md.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc, md.getDescriptorIndex()));
        }
        int currentCpLength = this.constantPool.length();
        for (i = 0; i < currentCpLength; ++i) {
            NameAndTypeCpInfo newNameTypeInfo;
            cpInfo = this.getCpEntry(i);
            if (!(cpInfo instanceof RefCpInfo)) continue;
            RefCpInfo refInfo = (RefCpInfo)cpInfo;
            ClassCpInfo classInfo = (ClassCpInfo)this.getCpEntry(refInfo.getClassIndex());
            String className = this.getUtf8(classInfo.getNameIndex());
            int ntIndex = refInfo.getNameAndTypeIndex();
            NameAndTypeCpInfo nameTypeInfo = (NameAndTypeCpInfo)this.getCpEntry(ntIndex);
            String ref = this.getUtf8(nameTypeInfo.getNameIndex());
            String desc2 = this.getUtf8(nameTypeInfo.getDescriptorIndex());
            String remapRef = cpInfo instanceof FieldrefCpInfo ? nm.mapField(className, ref) : nm.mapMethod(className, ref, desc2);
            String remapDesc2 = nm.mapDescriptor(desc2);
            if (remapRef.equals(ref) && remapDesc2.equals(desc2)) continue;
            if (nameTypeInfo.getRefCount() == 1) {
                newNameTypeInfo = nameTypeInfo;
            } else {
                newNameTypeInfo = (NameAndTypeCpInfo)nameTypeInfo.clone();
                this.getCpEntry(newNameTypeInfo.getNameIndex()).incRefCount();
                this.getCpEntry(newNameTypeInfo.getDescriptorIndex()).incRefCount();
                refInfo.setNameAndTypeIndex(this.constantPool.addEntry(newNameTypeInfo));
                newNameTypeInfo.incRefCount();
                nameTypeInfo.decRefCount();
            }
            newNameTypeInfo.setNameIndex(this.constantPool.remapUtf8To(remapRef, newNameTypeInfo.getNameIndex()));
            newNameTypeInfo.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc2, newNameTypeInfo.getDescriptorIndex()));
        }
        for (i = 0; i < this.constantPool.length(); ++i) {
            cpInfo = this.getCpEntry(i);
            if (!(cpInfo instanceof ClassCpInfo)) continue;
            ClassCpInfo classInfo = (ClassCpInfo)cpInfo;
            String className = this.getUtf8(classInfo.getNameIndex());
            String remapClass = nm.mapClass(className);
            int remapIndex = this.constantPool.remapUtf8To(remapClass, classInfo.getNameIndex());
            classInfo.setNameIndex(remapIndex);
        }
        for (AttrInfo at : this.attributes) {
            at.remap(this, nm);
        }
        for (MethodInfo md : this.methods) {
            for (AttrInfo at : md.attributes) {
                at.remap(this, nm);
            }
        }
        for (FieldInfo fd : this.fields) {
            for (AttrInfo at : fd.attributes) {
                at.remap(this, nm);
            }
        }
        if (enableMapClassString) {
            this.remapClassStrings(nm, log);
        }
    }

    private void remapClassStrings(NameMapper nm, PrintWriter log) throws ClassFileException {
        FlagHashtable cpToFlag = new FlagHashtable();
        for (MethodInfo methodInfo : this.methods) {
            for (AttrInfo attrInfo : methodInfo.attributes) {
                if (!(attrInfo instanceof CodeAttrInfo)) continue;
                cpToFlag = ((CodeAttrInfo)attrInfo).walkFindClassStrings(cpToFlag);
            }
        }
        HashMap<Integer, Integer> cpUpdate = new HashMap<Integer, Integer>();
        for (Map.Entry entry : cpToFlag.entrySet()) {
            String remapName;
            StringCpInfo stringCpInfo = (StringCpInfo)entry.getKey();
            StringCpInfoFlags flags = (StringCpInfoFlags)entry.getValue();
            String name = ClassFile.backTranslate(this.getUtf8(stringCpInfo.getStringIndex()));
            if (!ClassFile.isClassSpec(name) || !flags.forNameFlag || (remapName = nm.mapClass(name)).equals(name)) continue;
            boolean simpleRemap = false;
            if (flags.otherFlag) {
                int remapUtf8Index = this.constantPool.addUtf8Entry(ClassFile.translate(remapName));
                StringCpInfo remapStringInfo = new StringCpInfo();
                remapStringInfo.setStringIndex(remapUtf8Index);
                int remapStringIndex = this.constantPool.addEntry(remapStringInfo);
                if (remapStringIndex > 255) {
                    simpleRemap = true;
                    log.println("# WARNING MapClassString: non-.class/Class.forName() string remapped");
                } else {
                    log.println("# MapClassString (partial) in class " + this.getName() + ": " + name + " -> " + remapName);
                    cpUpdate.put(new Integer(flags.stringIndex), new Integer(remapStringIndex));
                }
            } else {
                simpleRemap = true;
            }
            if (!simpleRemap) continue;
            log.println("# MapClassString (full) in class " + this.getName() + ": " + name + " -> " + remapName);
            int remapIndex = this.constantPool.remapUtf8To(ClassFile.translate(remapName), stringCpInfo.getStringIndex());
            stringCpInfo.setStringIndex(remapIndex);
        }
        for (MethodInfo methodInfo : this.methods) {
            for (AttrInfo attrInfo : methodInfo.attributes) {
                if (!(attrInfo instanceof CodeAttrInfo)) continue;
                CodeAttrInfo codeAttrInfo = (CodeAttrInfo)attrInfo;
                codeAttrInfo.walkUpdateClassStrings(cpUpdate);
            }
        }
    }

    private static boolean isClassSpec(String s) {
        if (s.length() == 0) {
            return false;
        }
        int pos = -1;
        while ((pos = s.lastIndexOf(47)) != -1) {
            if (!ClassFile.isJavaIdentifier(s.substring(pos + 1))) {
                return false;
            }
            s = s.substring(0, pos);
        }
        return ClassFile.isJavaIdentifier(s);
    }

    private static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeInt(this.u4magic);
        dout.writeShort(this.u2minorVersion);
        dout.writeShort(this.u2majorVersion);
        dout.writeShort(this.constantPool.length() + (this.cpIdString != null ? 1 : 0));
        for (CpInfo cpInfo : this.constantPool) {
            if (cpInfo == null) continue;
            cpInfo.write(dout);
        }
        if (this.cpIdString != null) {
            this.cpIdString.write(dout);
        }
        dout.writeShort(this.u2accessFlags);
        dout.writeShort(this.u2thisClass);
        dout.writeShort(this.u2superClass);
        dout.writeShort(this.u2interfaces.size());
        Iterator<Object> i$ = this.u2interfaces.iterator();
        while (i$.hasNext()) {
            int intf = (Integer)i$.next();
            dout.writeShort(intf);
        }
        dout.writeShort(this.fields.size());
        for (FieldInfo fd : this.fields) {
            fd.write(dout);
        }
        dout.writeShort(this.methods.size());
        for (MethodInfo md : this.methods) {
            md.write(dout);
        }
        dout.writeShort(this.attributes.size());
        for (AttrInfo at : this.attributes) {
            at.write(dout);
        }
    }
}

