/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class ExceptionsAttrInfo
extends AttrInfo {
    private ArrayList<Integer> u2exceptionIndexTable;

    protected ExceptionsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "Exceptions";
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2numberOfExceptions = din.readUnsignedShort();
        this.u2exceptionIndexTable = new ArrayList(u2numberOfExceptions);
        for (int i = 0; i < u2numberOfExceptions; ++i) {
            this.u2exceptionIndexTable.add(din.readUnsignedShort());
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2exceptionIndexTable.size());
        for (int ex : this.u2exceptionIndexTable) {
            dout.writeShort(ex);
        }
    }
}

