/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.LineNumberInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LineNumberTableAttrInfo
extends AttrInfo {
    private List<LineNumberInfo> lineNumberTable;

    protected LineNumberTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LineNumberTable";
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2lineNumberTableLength = din.readUnsignedShort();
        this.lineNumberTable = new ArrayList<LineNumberInfo>(u2lineNumberTableLength);
        for (int i = 0; i < u2lineNumberTableLength; ++i) {
            this.lineNumberTable.add(LineNumberInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.lineNumberTable.size());
        for (LineNumberInfo ln : this.lineNumberTable) {
            ln.write(dout);
        }
    }
}

