/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SignatureAttrInfo
extends AttrInfo {
    private int u2signatureIndex;

    protected SignatureAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "Signature";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2signatureIndex);
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2signatureIndex = din.readUnsignedShort();
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2signatureIndex);
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        String newDesc;
        String oldDesc = cf.getUtf8(this.u2signatureIndex);
        switch (this.source) {
            case CLASS: {
                newDesc = nm.mapSignatureClass(oldDesc);
                break;
            }
            case METHOD: {
                newDesc = nm.mapSignatureMethod(oldDesc);
                break;
            }
            case FIELD: {
                newDesc = nm.mapSignatureField(oldDesc);
                break;
            }
            default: {
                throw new ClassFileException("Invalid attribute source");
            }
        }
        this.u2signatureIndex = cf.remapUtf8To(newDesc, this.u2signatureIndex);
    }
}

