/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import net.md_5.specialsource.Jar;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.Ownable;
import net.md_5.specialsource.util.NoDupeList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JarComparer
extends ClassVisitor {
    private final MethodReferenceFinder methodVisitor = new MethodReferenceFinder();
    public final Jar jar;
    private String myName;
    public int iterDepth;
    public NoDupeList<String> classes = new NoDupeList();
    public NoDupeList<Ownable> fields = new NoDupeList();
    public NoDupeList<Ownable> methods = new NoDupeList();

    private void visitType(Type type) {
        String name;
        if (type.getSort() == 10 && this.jar.containsClass(name = type.getInternalName())) {
            this.classes.add(name);
        }
    }

    public JarComparer(Jar jar) {
        super(262144);
        this.jar = jar;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myName = name;
        for (String implement : interfaces) {
            if (!this.jar.containsClass(implement)) continue;
            this.classes.add(implement);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Ownable field = new Ownable(NodeType.FIELD, this.myName, name, desc, access);
        this.fields.add(field);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!name.equals("<init>") && !name.equals("<clinit>")) {
            Ownable method = new Ownable(NodeType.METHOD, this.myName, name, desc, access);
            this.methods.add(method);
        }
        for (Type t : Type.getArgumentTypes(desc)) {
            this.visitType(t);
        }
        return this.methodVisitor;
    }

    private class MethodReferenceFinder
    extends MethodVisitor {
        public MethodReferenceFinder() {
            super(262144);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (JarComparer.this.jar.containsClass(owner)) {
                JarComparer.this.classes.add(owner);
            }
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                JarComparer.this.visitType((Type)cst);
            }
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (JarComparer.this.jar.containsClass(owner)) {
                JarComparer.this.classes.add(owner);
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (JarComparer.this.jar.containsClass(type)) {
                JarComparer.this.classes.add(type);
            }
        }
    }
}

