/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.primitives.Ints;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.UnsortedRemappingMethodAdapter;
import net.md_5.specialsource.repo.ClassRepo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.RemappingAnnotationAdapter;

public class RemappingClassAdapter
extends ClassVisitor {
    protected final CustomRemapper remapper;
    protected ClassRepo repo;
    protected String className;

    public RemappingClassAdapter(ClassVisitor cv, CustomRemapper remapper, ClassRepo repo) {
        this(327680, cv, remapper);
        this.repo = repo;
    }

    protected RemappingClassAdapter(int api, ClassVisitor cv, CustomRemapper remapper) {
        super(api, cv);
        this.remapper = remapper;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.remapper.mapType(name), this.remapper.mapSignature(signature, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(this.remapper.mapDesc(desc), visible);
        return av == null ? null : this.createRemappingAnnotationAdapter(av);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newDesc = this.remapper.mapMethodDesc(desc);
        MethodVisitor mv = super.visitMethod(access, this.remapper.mapMethodName(this.className, name, desc, access), newDesc, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return mv == null ? null : this.createRemappingMethodAdapter(access, newDesc, mv);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, this.remapper.mapFieldName(this.className, name, desc, access), this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), this.remapper.mapValue(value));
        return fv == null ? null : this.createRemappingFieldAdapter(fv);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String newInner;
        String newName = this.remapper.mapType(name);
        String string = newInner = newName.contains("$") ? newName.substring(newName.lastIndexOf(36) + 1) : null;
        if (newInner != null && Ints.tryParse(newInner) != null) {
            newInner = null;
        }
        super.visitInnerClass(newName, outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? newInner : (newInner != null ? newInner : newName.substring(newName.lastIndexOf(47) + 1)), access);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(this.remapper.mapType(owner), name == null ? null : this.remapper.mapMethodName(owner, name, desc), desc == null ? null : this.remapper.mapMethodDesc(desc));
    }

    protected FieldVisitor createRemappingFieldAdapter(FieldVisitor sup) {
        return new FieldVisitor(327680, sup){

            @Override
            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                if (this.fv != null) {
                    this.fv.visitAttribute(attr);
                }
            }
        };
    }

    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor sup) {
        UnsortedRemappingMethodAdapter remap = new UnsortedRemappingMethodAdapter(access, newDesc, sup, this.remapper, this.repo);
        return new MethodVisitor(327680, remap){

            @Override
            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                if (this.mv != null) {
                    this.mv.visitAttribute(attr);
                }
            }

            @Override
            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (!SpecialSource.kill_lvt) {
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            }
        };
    }

    protected AnnotationVisitor createRemappingAnnotationAdapter(AnnotationVisitor av) {
        return new RemappingAnnotationAdapter(av, this.remapper);
    }

    @Override
    public void visitSource(String source, String debug) {
        if (!SpecialSource.kill_source && this.cv != null) {
            this.cv.visitSource(source, debug);
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
        if (SpecialSource.kill_generics && attr.type.equals("Signature")) {
            return;
        }
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }
}

