/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableTypeInfo {
    private int u2startpc;
    private int u2length;
    private int u2nameIndex;
    private int u2signatureIndex;
    private int u2index;

    public static LocalVariableTypeInfo create(DataInput din) throws IOException {
        LocalVariableTypeInfo lvti = new LocalVariableTypeInfo();
        lvti.read(din);
        return lvti;
    }

    private LocalVariableTypeInfo() {
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected int getSignatureIndex() {
        return this.u2signatureIndex;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2signatureIndex);
    }

    private void read(DataInput din) throws IOException {
        this.u2startpc = din.readUnsignedShort();
        this.u2length = din.readUnsignedShort();
        this.u2nameIndex = din.readUnsignedShort();
        this.u2signatureIndex = din.readUnsignedShort();
        this.u2index = din.readUnsignedShort();
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2startpc);
        dout.writeShort(this.u2length);
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2signatureIndex);
        dout.writeShort(this.u2index);
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        String oldDesc = cf.getUtf8(this.u2signatureIndex);
        String newDesc = nm.mapSignatureField(oldDesc);
        this.u2signatureIndex = cf.remapUtf8To(newDesc, this.u2signatureIndex);
    }
}

