/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.NameMapper;
import COM.rl.obf.classfile.ParameterAnnotationsInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ParameterAnnotationsAttrInfo
extends AttrInfo {
    private List<ParameterAnnotationsInfo> parameterAnnotationsTable;

    protected ParameterAnnotationsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u1numParameters = din.readUnsignedByte();
        this.parameterAnnotationsTable = new ArrayList<ParameterAnnotationsInfo>(u1numParameters);
        for (int i = 0; i < u1numParameters; ++i) {
            this.parameterAnnotationsTable.add(ParameterAnnotationsInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeByte(this.parameterAnnotationsTable.size());
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.remap(cf, nm);
        }
    }
}

