/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprentStack;
import org.jetbrains.java.decompiler.modules.decompiler.PrimitiveExprsList;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;

public class ExprProcessor
implements CodeConstants {
    public static final String UNDEFINED_TYPE_STRING = "<undefinedtype>";
    public static final String UNKNOWN_TYPE_STRING = "<unknown>";
    public static final String NULL_TYPE_STRING = "<null>";
    private static final HashMap<Integer, Integer> mapConsts = new HashMap();
    private static final VarType[] consts;
    private static final VarType[] vartypes;
    private static final VarType[] arrtypes;
    private static final int[] func1;
    private static final int[] func2;
    private static final int[] func3;
    private static final int[] func4;
    private static final int[] func5;
    private static final int[] func6;
    private static final int[] func7;
    private static final int[] func8;
    private static final int[] arr_type;
    private static final int[] negifs;
    private static final String[] typeNames;
    private final VarProcessor varProcessor = (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR");

    public void processStatement(RootStatement root, StructClass cl) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        HashSet<String> setFinallyShortRangeEntryPoints = new HashSet<String>();
        for (List<FlattenStatementsHelper.FinallyPathWrapper> lst : dgraph.mapShortRangeFinallyPaths.values()) {
            for (FlattenStatementsHelper.FinallyPathWrapper finwrap : lst) {
                setFinallyShortRangeEntryPoints.add(finwrap.entry);
            }
        }
        HashSet<String> setFinallyLongRangeEntryPaths = new HashSet<String>();
        for (List<FlattenStatementsHelper.FinallyPathWrapper> lst : dgraph.mapLongRangeFinallyPaths.values()) {
            for (FlattenStatementsHelper.FinallyPathWrapper finwrap : lst) {
                setFinallyLongRangeEntryPaths.add(finwrap.source + "##" + finwrap.entry);
            }
        }
        HashMap<String, VarExprent> mapCatch = new HashMap<String, VarExprent>();
        ExprProcessor.collectCatchVars(root, flatthelper, mapCatch);
        HashMap mapData = new HashMap();
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        LinkedList stackEntryPoint = new LinkedList();
        stack.add(dgraph.first);
        stackEntryPoint.add(new LinkedList());
        HashMap<Object, PrimitiveExprsList> map = new HashMap<Object, PrimitiveExprsList>();
        map.put(null, new PrimitiveExprsList());
        mapData.put(dgraph.first, map);
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            LinkedList entrypoints = (LinkedList)stackEntryPoint.removeFirst();
            PrimitiveExprsList data = mapCatch.containsKey(node.id) ? ExprProcessor.getExpressionData((VarExprent)mapCatch.get(node.id)) : (PrimitiveExprsList)((Map)mapData.get(node)).get(ExprProcessor.buildEntryPointKey(entrypoints));
            BasicBlockStatement block = node.block;
            if (block != null) {
                this.processBlock(block, data, cl);
                block.setExprents(data.getLstExprents());
            }
            String currentEntrypoint = entrypoints.isEmpty() ? null : (String)entrypoints.getLast();
            for (DirectNode nd : node.succs) {
                String ndentrykey;
                boolean isSuccessor = true;
                if (currentEntrypoint != null && dgraph.mapLongRangeFinallyPaths.containsKey(node.id)) {
                    isSuccessor = false;
                    for (FlattenStatementsHelper.FinallyPathWrapper finwraplong : dgraph.mapLongRangeFinallyPaths.get(node.id)) {
                        if (!finwraplong.source.equals(currentEntrypoint) || !finwraplong.destination.equals(nd.id)) continue;
                        isSuccessor = true;
                        break;
                    }
                }
                if (!isSuccessor) continue;
                HashMap<String, PrimitiveExprsList> mapSucc = (HashMap<String, PrimitiveExprsList>)mapData.get(nd);
                if (mapSucc == null) {
                    mapSucc = new HashMap<String, PrimitiveExprsList>();
                    mapData.put(nd, mapSucc);
                }
                LinkedList<String> ndentrypoints = new LinkedList<String>(entrypoints);
                if (setFinallyLongRangeEntryPaths.contains(node.id + "##" + nd.id)) {
                    ndentrypoints.addLast(node.id);
                } else if (!setFinallyShortRangeEntryPoints.contains(nd.id) && dgraph.mapLongRangeFinallyPaths.containsKey(node.id)) {
                    ndentrypoints.removeLast();
                }
                int succ_entry_index = ndentrypoints.indexOf(nd.id);
                if (succ_entry_index >= 0) {
                    for (int elements_to_remove = ndentrypoints.size() - succ_entry_index; elements_to_remove > 0; --elements_to_remove) {
                        ndentrypoints.removeLast();
                    }
                }
                if (mapSucc.containsKey(ndentrykey = ExprProcessor.buildEntryPointKey(ndentrypoints))) continue;
                mapSucc.put(ndentrykey, ExprProcessor.copyVarExprents(data.copyStack()));
                stack.add(nd);
                stackEntryPoint.add(ndentrypoints);
            }
        }
        ExprProcessor.initStatementExprents(root);
    }

    private static String buildEntryPointKey(LinkedList<String> entrypoints) {
        if (entrypoints.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (String point : entrypoints) {
            buffer.append(point);
            buffer.append(":");
        }
        return buffer.toString();
    }

    private static PrimitiveExprsList copyVarExprents(PrimitiveExprsList data) {
        ExprentStack stack = data.getStack();
        ExprProcessor.copyEntries(stack);
        return data;
    }

    public static void copyEntries(List<Exprent> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            stack.set(i, stack.get(i).copy());
        }
    }

    private static void collectCatchVars(Statement stat, FlattenStatementsHelper flatthelper, Map<String, VarExprent> map) {
        List<VarExprent> lst = null;
        if (stat.type == 12) {
            CatchAllStatement catchall = (CatchAllStatement)stat;
            if (!catchall.isFinally()) {
                lst = catchall.getVars();
            }
        } else if (stat.type == 7) {
            lst = ((CatchStatement)stat).getVars();
        }
        if (lst != null) {
            for (int i = 1; i < stat.getStats().size(); ++i) {
                map.put(flatthelper.getMapDestinationNodes().get(((Statement)stat.getStats().get((int)i)).id)[0], lst.get(i - 1));
            }
        }
        for (Statement st : stat.getStats()) {
            ExprProcessor.collectCatchVars(st, flatthelper, map);
        }
    }

    private static void initStatementExprents(Statement stat) {
        stat.initExprents();
        for (Statement st : stat.getStats()) {
            ExprProcessor.initStatementExprents(st);
        }
    }

    public void processBlock(BasicBlockStatement stat, PrimitiveExprsList data, StructClass cl) {
        ConstantPool pool = cl.getPool();
        StructBootstrapMethodsAttribute bootstrap = (StructBootstrapMethodsAttribute)cl.getAttributes().getWithKey("BootstrapMethods");
        BasicBlock block = stat.getBlock();
        ExprentStack stack = data.getStack();
        List<Exprent> exprlist = data.getLstExprents();
        InstructionSequence seq = block.getSeq();
        block43: for (int i = 0; i < seq.length(); ++i) {
            Instruction instr = seq.getInstr(i);
            Integer bytecode_offset = block.getOldOffset(i);
            BitSet bytecode_offsets = null;
            if (bytecode_offset >= 0) {
                bytecode_offsets = new BitSet();
                bytecode_offsets.set(bytecode_offset);
            }
            switch (instr.opcode) {
                case 1: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_NULL, null, bytecode_offsets));
                    continue block43;
                }
                case 16: 
                case 17: {
                    this.pushEx(stack, exprlist, new ConstExprent(instr.getOperand(0), true, bytecode_offsets));
                    continue block43;
                }
                case 9: 
                case 10: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_LONG, new Long(instr.opcode - 9), bytecode_offsets));
                    continue block43;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_FLOAT, new Float(instr.opcode - 11), bytecode_offsets));
                    continue block43;
                }
                case 14: 
                case 15: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_DOUBLE, new Double(instr.opcode - 14), bytecode_offsets));
                    continue block43;
                }
                case 18: 
                case 19: 
                case 20: {
                    PooledConstant cn = pool.getConstant(instr.getOperand(0));
                    if (cn instanceof PrimitiveConstant) {
                        this.pushEx(stack, exprlist, new ConstExprent(consts[cn.type - 3], ((PrimitiveConstant)cn).value, bytecode_offsets));
                        continue block43;
                    }
                    if (!(cn instanceof LinkConstant)) continue block43;
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_STRING, ((LinkConstant)cn).elementname, bytecode_offsets));
                    continue block43;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    VarExprent varExprent = new VarExprent(instr.getOperand(0), vartypes[instr.opcode - 21], this.varProcessor);
                    this.varProcessor.findLVT(varExprent, bytecode_offset + instr.length());
                    this.pushEx(stack, exprlist, varExprent);
                    continue block43;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Exprent index = stack.pop();
                    Exprent arr = stack.pop();
                    VarType vartype = null;
                    switch (instr.opcode) {
                        case 47: {
                            vartype = VarType.VARTYPE_LONG;
                            break;
                        }
                        case 49: {
                            vartype = VarType.VARTYPE_DOUBLE;
                        }
                    }
                    this.pushEx(stack, exprlist, new ArrayExprent(arr, index, arrtypes[instr.opcode - 46], bytecode_offsets), vartype);
                    continue block43;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    Exprent top = stack.pop();
                    int varindex = instr.getOperand(0);
                    VarExprent varExprent = new VarExprent(varindex, vartypes[instr.opcode - 54], this.varProcessor);
                    this.varProcessor.findLVT(varExprent, bytecode_offset + instr.length());
                    AssignmentExprent assign = new AssignmentExprent(varExprent, top, bytecode_offsets);
                    exprlist.add(assign);
                    continue block43;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    Exprent value = stack.pop();
                    Exprent index_store = stack.pop();
                    Exprent arr_store = stack.pop();
                    AssignmentExprent arrassign = new AssignmentExprent(new ArrayExprent(arr_store, index_store, arrtypes[instr.opcode - 79], bytecode_offsets), value, bytecode_offsets);
                    exprlist.add(arrassign);
                    continue block43;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func1[(instr.opcode - 96) / 4], stack, bytecode_offsets));
                    continue block43;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func2[(instr.opcode - 120) / 2], stack, bytecode_offsets));
                    continue block43;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.pushEx(stack, exprlist, new FunctionExprent(13, stack, bytecode_offsets));
                    continue block43;
                }
                case 132: {
                    VarExprent vevar = new VarExprent(instr.getOperand(0), VarType.VARTYPE_INT, this.varProcessor);
                    this.varProcessor.findLVT(vevar, bytecode_offset + instr.length());
                    exprlist.add(new AssignmentExprent(vevar, new FunctionExprent(instr.getOperand(1) < 0 ? 1 : 0, Arrays.asList(vevar.copy(), new ConstExprent(VarType.VARTYPE_INT, Math.abs(instr.getOperand(1)), null)), bytecode_offsets), bytecode_offsets));
                    continue block43;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func3[instr.opcode - 133], stack, bytecode_offsets));
                    continue block43;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func4[instr.opcode - 148], stack, bytecode_offsets));
                    continue block43;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    exprlist.add(new IfExprent(negifs[func5[instr.opcode - 153]], stack, bytecode_offsets));
                    continue block43;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    exprlist.add(new IfExprent(negifs[func6[instr.opcode - 159]], stack, bytecode_offsets));
                    continue block43;
                }
                case 198: 
                case 199: {
                    exprlist.add(new IfExprent(negifs[func7[instr.opcode - 198]], stack, bytecode_offsets));
                    continue block43;
                }
                case 170: 
                case 171: {
                    exprlist.add(new SwitchExprent(stack.pop(), bytecode_offsets));
                    continue block43;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    exprlist.add(new ExitExprent(instr.opcode == 191 ? 1 : 0, instr.opcode == 177 ? null : stack.pop(), instr.opcode == 191 ? null : ((MethodDescriptor)DecompilerContext.getProperty((String)"CURRENT_METHOD_DESCRIPTOR")).ret, bytecode_offsets));
                    continue block43;
                }
                case 194: 
                case 195: {
                    exprlist.add(new MonitorExprent(func8[instr.opcode - 194], stack.pop(), bytecode_offsets));
                    continue block43;
                }
                case 192: 
                case 193: {
                    stack.push(new ConstExprent(new VarType(pool.getPrimitiveConstant(instr.getOperand(0)).getString(), true), null, null));
                }
                case 190: {
                    this.pushEx(stack, exprlist, new FunctionExprent((int)mapConsts.get(instr.opcode), stack, bytecode_offsets));
                    continue block43;
                }
                case 178: 
                case 180: {
                    this.pushEx(stack, exprlist, new FieldExprent(pool.getLinkConstant(instr.getOperand(0)), instr.opcode == 178 ? null : stack.pop(), bytecode_offsets));
                    continue block43;
                }
                case 179: 
                case 181: {
                    Exprent valfield = stack.pop();
                    FieldExprent exprfield = new FieldExprent(pool.getLinkConstant(instr.getOperand(0)), instr.opcode == 179 ? null : stack.pop(), bytecode_offsets);
                    exprlist.add(new AssignmentExprent(exprfield, valfield, bytecode_offsets));
                    continue block43;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    if (instr.opcode == 186 && instr.bytecode_version < 4) continue block43;
                    LinkConstant invoke_constant = pool.getLinkConstant(instr.getOperand(0));
                    int dynamic_invokation_type = -1;
                    if (instr.opcode == 186 && bootstrap != null) {
                        List<PooledConstant> bootstrap_arguments = bootstrap.getMethodArguments(invoke_constant.index1);
                        LinkConstant content_method_handle = (LinkConstant)bootstrap_arguments.get(1);
                        dynamic_invokation_type = content_method_handle.index1;
                    }
                    InvocationExprent exprinv = new InvocationExprent(instr.opcode, invoke_constant, stack, dynamic_invokation_type, bytecode_offsets);
                    if (exprinv.getDescriptor().ret.type == 10) {
                        exprlist.add(exprinv);
                        continue block43;
                    }
                    this.pushEx(stack, exprlist, exprinv);
                    continue block43;
                }
                case 187: 
                case 189: 
                case 197: {
                    int dimensions = instr.opcode == 187 ? 0 : (instr.opcode == 189 ? 1 : instr.getOperand(1));
                    VarType arrType = new VarType(pool.getPrimitiveConstant(instr.getOperand(0)).getString(), true);
                    if (instr.opcode != 197) {
                        arrType = arrType.resizeArrayDim(arrType.arrayDim + dimensions);
                    }
                    this.pushEx(stack, exprlist, new NewExprent(arrType, stack, dimensions, bytecode_offsets));
                    continue block43;
                }
                case 188: {
                    this.pushEx(stack, exprlist, new NewExprent(new VarType(arr_type[instr.getOperand(0) - 4], 1), stack, 1, bytecode_offsets));
                    continue block43;
                }
                case 89: {
                    this.pushEx(stack, exprlist, ((Exprent)stack.getByOffset(-1)).copy());
                    continue block43;
                }
                case 90: {
                    this.insertByOffsetEx(-2, stack, exprlist, -1);
                    continue block43;
                }
                case 91: {
                    if (((Exprent)stack.getByOffset((int)-2)).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-2, stack, exprlist, -1);
                        continue block43;
                    }
                    this.insertByOffsetEx(-3, stack, exprlist, -1);
                    continue block43;
                }
                case 92: {
                    if (((Exprent)stack.getByOffset((int)-1)).getExprType().stackSize == 2) {
                        this.pushEx(stack, exprlist, ((Exprent)stack.getByOffset(-1)).copy());
                        continue block43;
                    }
                    this.pushEx(stack, exprlist, ((Exprent)stack.getByOffset(-2)).copy());
                    this.pushEx(stack, exprlist, ((Exprent)stack.getByOffset(-2)).copy());
                    continue block43;
                }
                case 93: {
                    if (((Exprent)stack.getByOffset((int)-1)).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-2, stack, exprlist, -1);
                        continue block43;
                    }
                    this.insertByOffsetEx(-3, stack, exprlist, -2);
                    this.insertByOffsetEx(-3, stack, exprlist, -1);
                    continue block43;
                }
                case 94: {
                    if (((Exprent)stack.getByOffset((int)-1)).getExprType().stackSize == 2) {
                        if (((Exprent)stack.getByOffset((int)-2)).getExprType().stackSize == 2) {
                            this.insertByOffsetEx(-2, stack, exprlist, -1);
                            continue block43;
                        }
                        this.insertByOffsetEx(-3, stack, exprlist, -1);
                        continue block43;
                    }
                    if (((Exprent)stack.getByOffset((int)-3)).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-3, stack, exprlist, -2);
                        this.insertByOffsetEx(-3, stack, exprlist, -1);
                        continue block43;
                    }
                    this.insertByOffsetEx(-4, stack, exprlist, -2);
                    this.insertByOffsetEx(-4, stack, exprlist, -1);
                    continue block43;
                }
                case 95: {
                    this.insertByOffsetEx(-2, stack, exprlist, -1);
                    stack.pop();
                    continue block43;
                }
                case 87: 
                case 88: {
                    stack.pop();
                }
            }
        }
    }

    private void pushEx(ExprentStack stack, List<Exprent> exprlist, Exprent exprent) {
        this.pushEx(stack, exprlist, exprent, null);
    }

    private void pushEx(ExprentStack stack, List<Exprent> exprlist, Exprent exprent, VarType vartype) {
        int varindex = 10000 + stack.size();
        VarExprent var = new VarExprent(varindex, vartype == null ? exprent.getExprType() : vartype, this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        stack.push(var.copy());
    }

    private void insertByOffsetEx(int offset, ExprentStack stack, List<Exprent> exprlist, int copyoffset) {
        int base = 10000 + stack.size();
        LinkedList<VarExprent> lst = new LinkedList<VarExprent>();
        for (int i = -1; i >= offset; --i) {
            Exprent varex = stack.pop();
            VarExprent varnew = new VarExprent(base + i + 1, varex.getExprType(), this.varProcessor);
            varnew.setStack(true);
            exprlist.add(new AssignmentExprent(varnew, varex, null));
            lst.add(0, (VarExprent)varnew.copy());
        }
        Exprent exprent = ((VarExprent)lst.get(lst.size() + copyoffset)).copy();
        VarExprent var = new VarExprent(base + offset, exprent.getExprType(), this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        lst.add(0, (VarExprent)var.copy());
        for (VarExprent expr : lst) {
            stack.push(expr);
        }
    }

    public static String getTypeName(VarType type) {
        return ExprProcessor.getTypeName(type, true);
    }

    public static String getTypeName(VarType type, boolean getShort) {
        int tp = type.type;
        if (tp <= 7) {
            return typeNames[tp];
        }
        if (tp == 17) {
            return UNKNOWN_TYPE_STRING;
        }
        if (tp == 13) {
            return NULL_TYPE_STRING;
        }
        if (tp == 10) {
            return "void";
        }
        if (tp == 18 && type.isGeneric()) {
            return type.value;
        }
        if (tp == 8) {
            if (type.isGeneric()) {
                return ((GenericType)type).getCastName();
            }
            String ret = ExprProcessor.buildJavaClassName(type.value);
            if (getShort) {
                ret = DecompilerContext.getImportCollector().getShortName(ret);
            }
            if (ret == null) {
                ret = UNDEFINED_TYPE_STRING;
            }
            return ret;
        }
        throw new RuntimeException("invalid type");
    }

    public static String getCastTypeName(VarType type) {
        return ExprProcessor.getCastTypeName(type, true);
    }

    public static String getCastTypeName(VarType type, boolean getShort) {
        String s = ExprProcessor.getTypeName(type, getShort);
        int dim = type.arrayDim;
        while (dim-- > 0) {
            s = s + "[]";
        }
        return s;
    }

    public static PrimitiveExprsList getExpressionData(VarExprent var) {
        PrimitiveExprsList prlst = new PrimitiveExprsList();
        VarExprent vartmp = new VarExprent(10000, var.getExprType(), var.getProcessor());
        vartmp.setStack(true);
        prlst.getLstExprents().add(new AssignmentExprent(vartmp, var.copy(), null));
        prlst.getStack().push(vartmp.copy());
        return prlst;
    }

    public static boolean endsWithSemikolon(Exprent expr) {
        int type = expr.type;
        return type != 11 && type != 9 && type != 7 && (type != 12 || !((VarExprent)expr).isClassDef());
    }

    private static void addDeletedGotoInstructionMapping(Statement stat, BytecodeMappingTracer tracer) {
        BasicBlock block;
        List<Integer> offsets;
        if (stat instanceof BasicBlockStatement && !(offsets = (block = ((BasicBlockStatement)stat).getBlock()).getInstrOldOffsets()).isEmpty() && offsets.size() > block.getSeq().length()) {
            tracer.addMapping(offsets.get(offsets.size() - 1));
        }
    }

    public static TextBuffer jmpWrapper(Statement stat, int indent, boolean semicolon, BytecodeMappingTracer tracer) {
        StatEdge edge;
        TextBuffer buf = stat.toJava(indent, tracer);
        List<StatEdge> lstSuccs = stat.getSuccessorEdges(0x40000000);
        if (lstSuccs.size() == 1 && (edge = lstSuccs.get(0)).getType() != 1 && edge.explicit && edge.getDestination().type != 14) {
            buf.appendIndent(indent);
            switch (edge.getType()) {
                case 4: {
                    ExprProcessor.addDeletedGotoInstructionMapping(stat, tracer);
                    buf.append("break");
                    break;
                }
                case 8: {
                    ExprProcessor.addDeletedGotoInstructionMapping(stat, tracer);
                    buf.append("continue");
                }
            }
            if (edge.labeled) {
                buf.append(" label").append(edge.closure.getStartEndRange().start);
            }
            buf.append(";").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        if (buf.length() == 0 && semicolon) {
            buf.appendIndent(indent).append(";").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    public static String buildJavaClassName(String name) {
        StructClass cl;
        String res = name.replace('/', '.');
        if (res.contains("$") && ((cl = DecompilerContext.getStructContext().getClass(name)) == null || !cl.isOwn())) {
            res = res.replace('$', '.');
        }
        return res;
    }

    public static TextBuffer listToJava(List<Exprent> lst, int indent, BytecodeMappingTracer tracer) {
        if (lst == null || lst.isEmpty()) {
            return new TextBuffer();
        }
        TextBuffer buf = new TextBuffer();
        lst = Exprent.sortIndexed(lst);
        for (Exprent expr : lst) {
            expr.getInferredExprType(null);
            TextBuffer content = expr.toJava(indent, tracer);
            if (content.length() <= 0) continue;
            if (expr.type != 12 || !((VarExprent)expr).isClassDef()) {
                buf.appendIndent(indent);
            }
            buf.append(content);
            if (expr.type == 9 && ((MonitorExprent)expr).getMonType() == 0) {
                buf.append("{}");
            }
            if (ExprProcessor.endsWithSemikolon(expr)) {
                buf.append(";");
            }
            buf.appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    public static ConstExprent getDefaultArrayValue(VarType arrtype) {
        ConstExprent defaultval = arrtype.type == 8 || arrtype.arrayDim > 0 ? new ConstExprent(VarType.VARTYPE_NULL, null, null) : (arrtype.type == 3 ? new ConstExprent(VarType.VARTYPE_FLOAT, new Float(0.0f), null) : (arrtype.type == 5 ? new ConstExprent(VarType.VARTYPE_LONG, new Long(0L), null) : (arrtype.type == 2 ? new ConstExprent(VarType.VARTYPE_DOUBLE, new Double(0.0), null) : new ConstExprent(0, true, null))));
        return defaultval;
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, boolean castNull, BytecodeMappingTracer tracer) {
        return ExprProcessor.getCastedExprent(exprent, leftType, buffer, indent, castNull, false, tracer);
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, boolean castNull, boolean castAlways, BytecodeMappingTracer tracer) {
        boolean cast;
        VarType rightType = exprent.getInferredExprType(leftType);
        TextBuffer res = exprent.toJava(indent, tracer);
        boolean bl = cast = castAlways || !leftType.isSuperset(rightType) && (rightType.equals(VarType.VARTYPE_OBJECT) || leftType.type != 8) || castNull && rightType.type == 13 && !UNDEFINED_TYPE_STRING.equals(ExprProcessor.getTypeName(leftType)) || ExprProcessor.isIntConstant(exprent) && VarType.VARTYPE_INT.isStrictSuperset(leftType);
        if (cast) {
            if (exprent.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                res.enclose("(", ")");
            }
            res.prepend("(" + ExprProcessor.getCastTypeName(leftType) + ")");
        }
        buffer.append(res);
        return cast;
    }

    private static boolean isIntConstant(Exprent exprent) {
        if (exprent.type == 3) {
            ConstExprent cexpr = (ConstExprent)exprent;
            switch (cexpr.getConstType().type) {
                case 0: 
                case 4: 
                case 6: 
                case 15: 
                case 16: {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        mapConsts.put(new Integer(190), new Integer(31));
        mapConsts.put(new Integer(192), new Integer(29));
        mapConsts.put(new Integer(193), new Integer(30));
        consts = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_FLOAT, VarType.VARTYPE_LONG, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_CLASS, VarType.VARTYPE_STRING};
        vartypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT};
        arrtypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT, VarType.VARTYPE_BOOLEAN, VarType.VARTYPE_CHAR, VarType.VARTYPE_SHORT};
        func1 = new int[]{0, 1, 2, 3, 7};
        func2 = new int[]{8, 9, 10, 4, 5, 6};
        func3 = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
        func4 = new int[]{37, 38, 39, 40, 41};
        func5 = new int[]{0, 1, 2, 3, 4, 5};
        func6 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
        func7 = new int[]{6, 7};
        func8 = new int[]{0, 1};
        arr_type = new int[]{7, 1, 3, 2, 0, 6, 4, 5};
        negifs = new int[]{1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14};
        typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};
    }
}

