/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.StrongConnectivityHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.StartEndPair;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class Statement
implements IMatchable {
    public static final int STATEDGE_ALL = Integer.MIN_VALUE;
    public static final int STATEDGE_DIRECT_ALL = 0x40000000;
    public static final int DIRECTION_BACKWARD = 0;
    public static final int DIRECTION_FORWARD = 1;
    public static final int TYPE_GENERAL = 0;
    public static final int TYPE_IF = 2;
    public static final int TYPE_DO = 5;
    public static final int TYPE_SWITCH = 6;
    public static final int TYPE_TRYCATCH = 7;
    public static final int TYPE_BASICBLOCK = 8;
    public static final int TYPE_FINALLY = 9;
    public static final int TYPE_SYNCRONIZED = 10;
    public static final int TYPE_PLACEHOLDER = 11;
    public static final int TYPE_CATCHALL = 12;
    public static final int TYPE_ROOT = 13;
    public static final int TYPE_DUMMYEXIT = 14;
    public static final int TYPE_SEQUENCE = 15;
    public static final int LASTBASICTYPE_IF = 0;
    public static final int LASTBASICTYPE_SWITCH = 1;
    public static final int LASTBASICTYPE_GENERAL = 2;
    public int type;
    public Integer id;
    private final Map<Integer, List<StatEdge>> mapSuccEdges = new HashMap<Integer, List<StatEdge>>();
    private final Map<Integer, List<StatEdge>> mapPredEdges = new HashMap<Integer, List<StatEdge>>();
    private final Map<Integer, List<Statement>> mapSuccStates = new HashMap<Integer, List<Statement>>();
    private final Map<Integer, List<Statement>> mapPredStates = new HashMap<Integer, List<Statement>>();
    protected final VBStyleCollection<Statement, Integer> stats = new VBStyleCollection();
    protected Statement parent;
    protected Statement first;
    protected List<Exprent> exprents;
    protected final HashSet<StatEdge> labelEdges = new HashSet();
    protected final List<Exprent> varDefinitions = new ArrayList<Exprent>();
    private boolean copied = false;
    protected Statement post;
    protected int lastBasicType = 2;
    protected boolean isMonitorEnter;
    protected boolean containsMonitorExit;
    protected HashSet<Statement> continueSet = new HashSet();
    private StartEndPair endpoints;

    public Statement() {
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(0);
    }

    public void clearTempInformation() {
        this.post = null;
        this.continueSet = null;
        this.copied = false;
        this.isMonitorEnter = false;
        this.containsMonitorExit = false;
        Statement.processMap(this.mapSuccEdges);
        Statement.processMap(this.mapPredEdges);
        Statement.processMap(this.mapSuccStates);
        Statement.processMap(this.mapPredStates);
    }

    private static <T> void processMap(Map<Integer, List<T>> map) {
        map.remove(2);
        List<T> lst = map.get(0x40000000);
        if (lst != null) {
            map.put(Integer.MIN_VALUE, new ArrayList<T>(lst));
        } else {
            map.remove(Integer.MIN_VALUE);
        }
    }

    public void collapseNodesToStatement(Statement stat) {
        Statement head = stat.getFirst();
        Statement post = stat.getPost();
        VBStyleCollection<Statement, Integer> setNodes = stat.getStats();
        if (post != null) {
            for (StatEdge edge : post.getEdges(0x40000000, 0)) {
                if (!stat.containsStatementStrict(edge.getSource())) continue;
                edge.getSource().changeEdgeType(1, edge, 4);
                stat.addLabeledEdge(edge);
            }
        }
        for (StatEdge prededge : head.getAllPredecessorEdges()) {
            if (prededge.getType() != 2 && stat.containsStatementStrict(prededge.getSource())) {
                prededge.getSource().changeEdgeType(1, prededge, 8);
                stat.addLabeledEdge(prededge);
            }
            head.removePredecessor(prededge);
            prededge.getSource().changeEdgeNode(1, prededge, stat);
            stat.addPredecessor(prededge);
        }
        if (setNodes.containsKey(this.first.id)) {
            this.first = stat;
        }
        HashSet<Statement> setHandlers = new HashSet<Statement>(head.getNeighbours(2, 1));
        for (Statement node : setNodes) {
            setHandlers.retainAll(node.getNeighbours(2, 1));
        }
        if (!setHandlers.isEmpty()) {
            for (StatEdge edge : head.getEdges(2, 1)) {
                Statement handler = edge.getDestination();
                if (!setHandlers.contains(handler) || setNodes.containsKey(handler.id)) continue;
                stat.addSuccessor(new StatEdge(stat, handler, edge.getExceptions()));
            }
            for (Statement node : setNodes) {
                for (StatEdge edge : node.getEdges(2, 1)) {
                    if (!setHandlers.contains(edge.getDestination())) continue;
                    node.removeSuccessor(edge);
                }
            }
        }
        if (post != null && !stat.getNeighbours(2, 1).contains(post)) {
            stat.addSuccessor(new StatEdge(1, stat, post));
        }
        for (Statement st : setNodes) {
            this.stats.removeWithKey(st.id);
        }
        this.stats.addWithKey(stat, stat.id);
        stat.setAllParent();
        stat.setParent(this);
        stat.buildContinueSet();
        stat.buildMonitorFlags();
        if (stat.type == 6) {
            ((SwitchStatement)stat).sortEdgesAndNodes();
        }
    }

    public void setAllParent() {
        for (Statement st : this.stats) {
            st.setParent(this);
        }
    }

    public void addLabeledEdge(StatEdge edge) {
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        edge.closure = this;
        this.getLabelEdges().add(edge);
    }

    private void addEdgeDirectInternal(int direction, StatEdge edge, int edgetype) {
        Map<Integer, List<StatEdge>> mapEdges = direction == 0 ? this.mapPredEdges : this.mapSuccEdges;
        Map<Integer, List<Statement>> mapStates = direction == 0 ? this.mapPredStates : this.mapSuccStates;
        List<StatEdge> lst = mapEdges.get(edgetype);
        if (lst == null) {
            lst = new ArrayList<StatEdge>();
            mapEdges.put(edgetype, lst);
        }
        lst.add(edge);
        List<Statement> lstStates = mapStates.get(edgetype);
        if (lstStates == null) {
            lstStates = new ArrayList<Statement>();
            mapStates.put(edgetype, lstStates);
        }
        lstStates.add(direction == 0 ? edge.getSource() : edge.getDestination());
    }

    private void addEdgeInternal(int direction, StatEdge edge) {
        int type = edge.getType();
        int[] arrtypes = type == 2 ? new int[]{Integer.MIN_VALUE, 2} : new int[]{Integer.MIN_VALUE, 0x40000000, type};
        for (int edgetype : arrtypes) {
            this.addEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    private void removeEdgeDirectInternal(int direction, StatEdge edge, int edgetype) {
        int index;
        Map<Integer, List<StatEdge>> mapEdges = direction == 0 ? this.mapPredEdges : this.mapSuccEdges;
        Map<Integer, List<Statement>> mapStates = direction == 0 ? this.mapPredStates : this.mapSuccStates;
        List<StatEdge> lst = mapEdges.get(edgetype);
        if (lst != null && (index = lst.indexOf(edge)) >= 0) {
            lst.remove(index);
            mapStates.get(edgetype).remove(index);
        }
    }

    private void removeEdgeInternal(int direction, StatEdge edge) {
        int type = edge.getType();
        int[] arrtypes = type == 2 ? new int[]{Integer.MIN_VALUE, 2} : new int[]{Integer.MIN_VALUE, 0x40000000, type};
        for (int edgetype : arrtypes) {
            this.removeEdgeDirectInternal(direction, edge, edgetype);
        }
    }

    public void addPredecessor(StatEdge edge) {
        this.addEdgeInternal(0, edge);
    }

    public void removePredecessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(0, edge);
    }

    public void addSuccessor(StatEdge edge) {
        this.addEdgeInternal(1, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().add(edge);
        }
        edge.getDestination().addPredecessor(edge);
    }

    public void removeSuccessor(StatEdge edge) {
        if (edge == null) {
            return;
        }
        this.removeEdgeInternal(1, edge);
        if (edge.closure != null) {
            edge.closure.getLabelEdges().remove(edge);
        }
        if (edge.getDestination() != null) {
            edge.getDestination().removePredecessor(edge);
        }
    }

    public void removeAllSuccessors(Statement stat) {
        if (stat == null) {
            return;
        }
        for (StatEdge edge : this.getAllSuccessorEdges()) {
            if (edge.getDestination() != stat) continue;
            this.removeSuccessor(edge);
        }
    }

    public HashSet<Statement> buildContinueSet() {
        this.continueSet.clear();
        for (Statement st : this.stats) {
            this.continueSet.addAll(st.buildContinueSet());
            if (st == this.first) continue;
            this.continueSet.remove(st.getBasichead());
        }
        for (StatEdge edge : this.getEdges(8, 1)) {
            this.continueSet.add(edge.getDestination().getBasichead());
        }
        if (this.type == 5) {
            this.continueSet.remove(this.first.getBasichead());
        }
        return this.continueSet;
    }

    public void buildMonitorFlags() {
        for (Statement st : this.stats) {
            st.buildMonitorFlags();
        }
        switch (this.type) {
            case 8: {
                BasicBlockStatement bblock = (BasicBlockStatement)this;
                InstructionSequence seq = bblock.getBlock().getSeq();
                if (seq == null || seq.length() <= 0) break;
                for (int i = 0; i < seq.length(); ++i) {
                    if (seq.getInstr((int)i).opcode != 195) continue;
                    this.containsMonitorExit = true;
                    break;
                }
                this.isMonitorEnter = seq.getLastInstr().opcode == 194;
                break;
            }
            case 2: 
            case 15: {
                this.containsMonitorExit = false;
                for (Statement st : this.stats) {
                    this.containsMonitorExit |= st.isContainsMonitorExit();
                }
                break;
            }
            case 0: 
            case 10: 
            case 13: {
                break;
            }
            default: {
                this.containsMonitorExit = false;
                for (Statement st : this.stats) {
                    this.containsMonitorExit |= st.isContainsMonitorExit();
                }
            }
        }
    }

    public List<Statement> getReversePostOrderList() {
        return this.getReversePostOrderList(this.first);
    }

    public List<Statement> getReversePostOrderList(Statement stat) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        Statement.addToReversePostOrderListIterative(stat, res);
        return res;
    }

    public List<Statement> getPostReversePostOrderList() {
        return this.getPostReversePostOrderList(null);
    }

    public List<Statement> getPostReversePostOrderList(List<Statement> lstexits) {
        ArrayList<Statement> res = new ArrayList<Statement>();
        if (lstexits == null) {
            StrongConnectivityHelper schelper = new StrongConnectivityHelper(this);
            lstexits = StrongConnectivityHelper.getExitReps(schelper.getComponents());
        }
        HashSet<Statement> setVisited = new HashSet<Statement>();
        for (Statement exit : lstexits) {
            Statement.addToPostReversePostOrderList(exit, res, setVisited);
        }
        if (res.size() != this.stats.size()) {
            throw new RuntimeException("computing post reverse post order failed!");
        }
        return res;
    }

    public boolean containsStatement(Statement stat) {
        return this == stat || this.containsStatementStrict(stat);
    }

    public boolean containsStatementStrict(Statement stat) {
        if (this.stats.contains(stat)) {
            return true;
        }
        for (int i = 0; i < this.stats.size(); ++i) {
            if (!((Statement)this.stats.get(i)).containsStatementStrict(stat)) continue;
            return true;
        }
        return false;
    }

    public TextBuffer toJava() {
        return this.toJava(0, new BytecodeMappingTracer());
    }

    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        throw new RuntimeException("not implemented");
    }

    public List<Object> getSequentialObjects() {
        return new ArrayList<Object>(this.stats);
    }

    public void initExprents() {
    }

    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
    }

    public Statement getSimpleCopy() {
        throw new RuntimeException("not implemented");
    }

    public void initSimpleCopy() {
        if (!this.stats.isEmpty()) {
            this.first = (Statement)this.stats.get(0);
        }
    }

    public void replaceStatement(Statement oldstat, Statement newstat) {
        for (StatEdge edge : oldstat.getAllPredecessorEdges()) {
            oldstat.removePredecessor(edge);
            edge.getSource().changeEdgeNode(1, edge, newstat);
            newstat.addPredecessor(edge);
        }
        for (StatEdge edge : oldstat.getAllSuccessorEdges()) {
            oldstat.removeSuccessor(edge);
            edge.setSource(newstat);
            newstat.addSuccessor(edge);
        }
        int statindex = this.stats.getIndexByKey(oldstat.id);
        this.stats.removeWithKey(oldstat.id);
        this.stats.addWithKeyAndIndex(statindex, newstat, newstat.id);
        newstat.setParent(this);
        newstat.post = oldstat.post;
        if (this.first == oldstat) {
            this.first = newstat;
        }
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(oldstat.getLabelEdges());
        for (int i = lst.size() - 1; i >= 0; --i) {
            StatEdge edge = (StatEdge)lst.get(i);
            if (edge.getSource() != newstat) {
                newstat.addLabeledEdge(edge);
                continue;
            }
            if (this == edge.getDestination() || this.containsStatementStrict(edge.getDestination())) {
                edge.closure = null;
                continue;
            }
            this.addLabeledEdge(edge);
        }
        oldstat.getLabelEdges().clear();
    }

    private static void addToReversePostOrderListIterative(Statement root, List<Statement> lst) {
        LinkedList<Statement> stackNode = new LinkedList<Statement>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<Statement> setVisited = new HashSet<Statement>();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            int index;
            Statement node = (Statement)stackNode.getLast();
            setVisited.add(node);
            List<StatEdge> lstEdges = node.getAllSuccessorEdges();
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstEdges.size(); ++index) {
                StatEdge edge = lstEdges.get(index);
                Statement succ = edge.getDestination();
                if (setVisited.contains(succ) || edge.getType() != 1 && edge.getType() != 2) continue;
                stackIndex.add(index + 1);
                stackNode.add(succ);
                stackIndex.add(0);
                break;
            }
            if (index != lstEdges.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }

    private static void addToPostReversePostOrderList(Statement stat, List<Statement> lst, HashSet<Statement> setVisited) {
        if (setVisited.contains(stat)) {
            return;
        }
        setVisited.add(stat);
        for (StatEdge prededge : stat.getEdges(3, 0)) {
            Statement pred = prededge.getSource();
            if (setVisited.contains(pred)) continue;
            Statement.addToPostReversePostOrderList(pred, lst, setVisited);
        }
        lst.add(0, stat);
    }

    public void changeEdgeNode(int direction, StatEdge edge, Statement value) {
        Map<Integer, List<StatEdge>> mapEdges = direction == 0 ? this.mapPredEdges : this.mapSuccEdges;
        Map<Integer, List<Statement>> mapStates = direction == 0 ? this.mapPredStates : this.mapSuccStates;
        int type = edge.getType();
        int[] arrtypes = type == 2 ? new int[]{Integer.MIN_VALUE, 2} : new int[]{Integer.MIN_VALUE, 0x40000000, type};
        for (int edgetype : arrtypes) {
            int index;
            List<StatEdge> lst = mapEdges.get(edgetype);
            if (lst == null || (index = lst.indexOf(edge)) < 0) continue;
            mapStates.get(edgetype).set(index, value);
        }
        if (direction == 0) {
            edge.setSource(value);
        } else {
            edge.setDestination(value);
        }
    }

    public void changeEdgeType(int direction, StatEdge edge, int newtype) {
        int oldtype = edge.getType();
        if (oldtype == newtype) {
            return;
        }
        if (oldtype == 2 || newtype == 2) {
            throw new RuntimeException("Invalid edge type!");
        }
        this.removeEdgeDirectInternal(direction, edge, oldtype);
        this.addEdgeDirectInternal(direction, edge, newtype);
        if (direction == 1) {
            edge.getDestination().changeEdgeType(0, edge, newtype);
        }
        edge.setType(newtype);
    }

    private List<StatEdge> getEdges(int type, int direction) {
        List<Object> res;
        Map<Integer, List<StatEdge>> map;
        Map<Integer, List<StatEdge>> map2 = map = direction == 0 ? this.mapPredEdges : this.mapSuccEdges;
        if ((type & type - 1) == 0) {
            res = map.get(type);
            res = res == null ? new ArrayList() : new ArrayList(res);
        } else {
            res = new ArrayList();
            for (int edgetype : StatEdge.TYPES) {
                List<StatEdge> lst;
                if ((type & edgetype) == 0 || (lst = map.get(edgetype)) == null) continue;
                res.addAll(lst);
            }
        }
        return res;
    }

    public List<Statement> getNeighbours(int type, int direction) {
        List<Object> res;
        Map<Integer, List<Statement>> map;
        Map<Integer, List<Statement>> map2 = map = direction == 0 ? this.mapPredStates : this.mapSuccStates;
        if ((type & type - 1) == 0) {
            res = map.get(type);
            res = res == null ? new ArrayList() : new ArrayList(res);
        } else {
            res = new ArrayList();
            for (int edgetype : StatEdge.TYPES) {
                List<Statement> lst;
                if ((type & edgetype) == 0 || (lst = map.get(edgetype)) == null) continue;
                res.addAll(lst);
            }
        }
        return res;
    }

    public Set<Statement> getNeighboursSet(int type, int direction) {
        return new HashSet<Statement>(this.getNeighbours(type, direction));
    }

    public List<StatEdge> getSuccessorEdges(int type) {
        return this.getEdges(type, 1);
    }

    public List<StatEdge> getPredecessorEdges(int type) {
        return this.getEdges(type, 0);
    }

    public List<StatEdge> getAllSuccessorEdges() {
        return this.getEdges(Integer.MIN_VALUE, 1);
    }

    public List<StatEdge> getAllPredecessorEdges() {
        return this.getEdges(Integer.MIN_VALUE, 0);
    }

    public Statement getFirst() {
        return this.first;
    }

    public void setFirst(Statement first) {
        this.first = first;
    }

    public Statement getPost() {
        return this.post;
    }

    public void setPost(Statement post) {
        this.post = post;
    }

    public VBStyleCollection<Statement, Integer> getStats() {
        return this.stats;
    }

    public int getLastBasicType() {
        return this.lastBasicType;
    }

    public HashSet<Statement> getContinueSet() {
        return this.continueSet;
    }

    public boolean isContainsMonitorExit() {
        return this.containsMonitorExit;
    }

    public boolean isMonitorEnter() {
        return this.isMonitorEnter;
    }

    public BasicBlockStatement getBasichead() {
        if (this.type == 8) {
            return (BasicBlockStatement)this;
        }
        return this.first.getBasichead();
    }

    public boolean isLabeled() {
        for (StatEdge edge : this.labelEdges) {
            if (!edge.labeled || !edge.explicit) continue;
            return true;
        }
        return false;
    }

    public boolean hasBasicSuccEdge() {
        return this.type == 8 || this.type == 2 && ((IfStatement)this).iftype == 0 || this.type == 5 && ((DoStatement)this).getLooptype() != 0;
    }

    public Statement getParent() {
        return this.parent;
    }

    public void setParent(Statement parent) {
        this.parent = parent;
    }

    public Statement getTopParent() {
        Statement ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        return ret;
    }

    public HashSet<StatEdge> getLabelEdges() {
        return this.labelEdges;
    }

    public List<Exprent> getVarDefinitions() {
        return this.varDefinitions;
    }

    public List<Exprent> getExprents() {
        return this.exprents;
    }

    public void setExprents(List<Exprent> exprents) {
        this.exprents = exprents;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public void setCopied(boolean copied) {
        this.copied = copied;
    }

    public String toString() {
        return String.format("{%d}:%d", this.type, this.id);
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        int node_type = matchNode.getType();
        if (node_type == 0 && !this.stats.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.STATEMENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return (IMatchable)this.stats.get((this.stats.size() + Integer.parseInt(position)) % this.stats.size());
                }
            } else if (index < this.stats.size()) {
                return (IMatchable)this.stats.get(index);
            }
        } else if (node_type == 1 && this.exprents != null && !this.exprents.isEmpty()) {
            String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION);
            if (position != null) {
                if (position.matches("-?\\d+")) {
                    return this.exprents.get((this.exprents.size() + Integer.parseInt(position)) % this.exprents.size());
                }
            } else if (index < this.exprents.size()) {
                return this.exprents.get(index);
            }
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (matchNode.getType() != 0) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            switch (rule.getKey()) {
                case STATEMENT_TYPE: {
                    if (this.type == (Integer)rule.getValue().value) break;
                    return false;
                }
                case STATEMENT_STATSIZE: {
                    if (this.stats.size() == ((Integer)rule.getValue().value).intValue()) break;
                    return false;
                }
                case STATEMENT_EXPRSIZE: {
                    int exprsize = (Integer)rule.getValue().value;
                    if (!(exprsize == -1 ? this.exprents != null : this.exprents == null || this.exprents.size() != exprsize)) break;
                    return false;
                }
                case STATEMENT_RET: {
                    if (engine.checkAndSetVariableValue((String)rule.getValue().value, this)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public StartEndPair getStartEndRange() {
        if (this.endpoints == null) {
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            for (Statement st : this.getStats()) {
                start = Math.min(start, st.getBasichead().getBlock().getStartInstruction());
                end = Math.max(end, st.getBasichead().getBlock().getEndInstruction());
            }
            this.endpoints = new StartEndPair(start, end);
        }
        return this.endpoints;
    }
}

