/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LVTVariable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LocalVariableTable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarProcessor {
    private Map<VarVersionPair, String> mapVarNames = new HashMap<VarVersionPair, String>();
    private Map<VarVersionPair, LVTVariable> mapVarLVTs = new HashMap<VarVersionPair, LVTVariable>();
    private VarVersionsProcessor varVersions;
    private final Map<VarVersionPair, String> thisVars = new HashMap<VarVersionPair, String>();
    private final Set<VarVersionPair> externalVars = new HashSet<VarVersionPair>();
    private LocalVariableTable lvt;

    public void setVarVersions(RootStatement root) {
        Map<Integer, VarVersionPair> mapOriginalVarIndices = null;
        if (this.varVersions != null) {
            mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        }
        this.varVersions = new VarVersionsProcessor();
        this.varVersions.setVarVersions(root);
        if (mapOriginalVarIndices != null) {
            this.varVersions.getMapOriginalVarIndices().putAll(mapOriginalVarIndices);
        }
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap<VarVersionPair, String>();
        StructMethod mt = (StructMethod)DecompilerContext.getProperty("CURRENT_METHOD");
        new VarDefinitionHelper(root, mt, this).setVarDefinitions();
    }

    public void setDebugVarNames(Map<Integer, List<LVTVariable>> mapDebugVarNames) {
        if (this.varVersions == null) {
            return;
        }
        Map<Integer, VarVersionPair> mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        ArrayList<VarVersionPair> listVars = new ArrayList<VarVersionPair>(this.mapVarNames.keySet());
        Collections.sort(listVars, new Comparator<VarVersionPair>(){

            @Override
            public int compare(VarVersionPair o1, VarVersionPair o2) {
                return o1.var - o2.var;
            }
        });
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        HashMap<Integer, TreeSet<VarVersionPair>> indexedPairs = new HashMap<Integer, TreeSet<VarVersionPair>>();
        Comparator<VarVersionPair> vvpVersionComparator = new Comparator<VarVersionPair>(){

            @Override
            public int compare(VarVersionPair o1, VarVersionPair o2) {
                return o1.version - o2.version;
            }
        };
        for (Map.Entry<Integer, VarVersionPair> vvp : mapOriginalVarIndices.entrySet()) {
            TreeSet<VarVersionPair> set = (TreeSet<VarVersionPair>)indexedPairs.get(vvp.getValue().var);
            if (set == null) {
                set = new TreeSet<VarVersionPair>(vvpVersionComparator);
                indexedPairs.put(vvp.getValue().var, set);
            }
            set.add(vvp.getValue());
        }
        for (VarVersionPair pair : listVars) {
            Integer counter;
            String name = this.mapVarNames.get(pair);
            VarVersionPair key = mapOriginalVarIndices.get(pair.var);
            boolean lvtName = false;
            if (key != null && indexedPairs.containsKey(key.var)) {
                int veridx = ((SortedSet)indexedPairs.get(key.var)).headSet(key).size();
                List<LVTVariable> list = mapDebugVarNames.get(key.var);
                if (list != null && list.size() > veridx) {
                    name = list.get((int)veridx).name;
                    lvtName = true;
                } else if (list == null) {
                    // empty if block
                }
            }
            mapNames.put(name, (counter = (Integer)mapNames.get(name)) == null ? (counter = new Integer(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0 && !lvtName) {
                name = name + String.valueOf(counter);
            }
            this.mapVarNames.put(pair, name);
        }
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersionPair, String> tempVarNames = new HashMap<VarVersionPair, String>(this.mapVarNames);
        for (Map.Entry ent : tempVarNames.entrySet()) {
            this.mapVarNames.put((VarVersionPair)ent.getKey(), vc.getFreeName((String)ent.getValue()));
        }
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.varVersions == null ? null : this.varVersions.getVarType(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        if (this.varVersions != null) {
            this.varVersions.setVarType(pair, type);
        }
    }

    public String getVarName(VarVersionPair pair) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(pair);
    }

    public void setVarName(VarVersionPair pair, String name) {
        this.mapVarNames.put(pair, name);
    }

    public int getVarFinal(VarVersionPair pair) {
        return this.varVersions == null ? 3 : this.varVersions.getVarFinal(pair);
    }

    public void setVarFinal(VarVersionPair pair, int finalType) {
        this.varVersions.setVarFinal(pair, finalType);
    }

    public Map<VarVersionPair, String> getThisVars() {
        return this.thisVars;
    }

    public Set<VarVersionPair> getExternalVars() {
        return this.externalVars;
    }

    public void setLVT(LocalVariableTable lvt) {
        this.lvt = lvt;
    }

    public LocalVariableTable getLVT() {
        return this.lvt;
    }

    public void findLVT(VarExprent varExprent, int bytecodeOffset) {
        LVTVariable var;
        LVTVariable lVTVariable = var = this.lvt == null ? null : this.lvt.find(varExprent.getIndex(), bytecodeOffset);
        if (var != null) {
            varExprent.setLVT(var);
        }
    }

    public int getRemapped(int index) {
        VarVersionPair res = this.varVersions.getMapOriginalVarIndices().get(index);
        if (res == null) {
            return index;
        }
        return res.var;
    }

    public void copyVarInfo(VarVersionPair from, VarVersionPair to) {
        this.setVarName(to, this.getVarName(from));
        this.setVarFinal(to, this.getVarFinal(from));
        this.setVarType(to, this.getVarType(from));
        this.varVersions.getMapOriginalVarIndices().put(to.var, this.varVersions.getMapOriginalVarIndices().get(from.var));
    }

    public VarVersionsProcessor getVarVersions() {
        return this.varVersions;
    }

    public void setVarLVT(VarVersionPair var, LVTVariable lvt) {
        this.mapVarLVTs.put(var, lvt);
    }

    public LVTVariable getVarLVT(VarVersionPair var) {
        return this.mapVarLVTs.get(var);
    }
}

